@echo off
chcp 65001 > nul
title 帆船AmongUs服务器工具箱 - v2.7

:: 设置颜色
for /f "delims=#" %%a in ('"prompt #$E# & for %%a in (1) do rem"') do set "ESC=%%a"
set "GREEN=%ESC%[92m"
set "YELLOW=%ESC%[93m"
set "CYAN=%ESC%[96m"
set "RED=%ESC%[91m"
set "BLUE=%ESC%[94m"
set "MAGENTA=%ESC%[95m"
set "ORANGE=%ESC%[38;5;214m"
set "PURPLE=%ESC%[38;5;129m"
set "GOLD=%ESC%[38;5;220m"
set "RESET=%ESC%[0m"

:: 隐藏光标
echo %ESC%[?25l

:: 检查管理员权限
call :check_admin_privileges

:: 确保C盘文件夹存在
if not exist "C:\fanchuanauserver" (
    mkdir "C:\fanchuanauserver" >nul 2>&1
)

:: 显示启动画面
call :startup_screen

:: 初始化界面
call :loading_screen_with_banner "正在初始化系统" 5

:: 检查依赖项界面
call :loading_screen_with_banner "正在检查依赖项" 5

:: 检查系统版本界面
call :loading_screen_with_banner "正在检查系统版本" 5

:: 检查旧配置文件
if exist "C:\fanchuanauserver" (
    call :check_old_config
)

:: 显示主菜单
:main_menu
call :display_header "主菜单"
echo.
echo        %GREEN%[1]%RESET% 检查工具箱版本更新（安装前推荐检查）
echo.
echo        %ORANGE%[2]%RESET% 安装帆船AmongUs服务器
echo.
echo        %ORANGE%[3]%RESET% 修复旧版游戏
echo.
echo        %BLUE%[4]%RESET% 跳转其他官方链接
echo.
echo        %BLUE%[5]%RESET% 前往官方Q群联系服主
echo.
echo        %YELLOW%[6]%RESET% 玩服务器遇到问题？选此项目跳转到帆船服疑难解答！
echo.
echo        %YELLOW%[7]%RESET% 帆船服掉线诊断/连接网络测试
echo.
echo        %BLUE%[8]%RESET% 关于此脚本（脚本更新日志）
echo.
echo        %RED%[0]%RESET% 退出此脚本
echo.
echo.
set /p "choice=        请选择 [0-8]: "

if /i "%choice%"=="1" (
    goto :check_update
) else if "%choice%"=="2" (
    goto :install_menu
) else if "%choice%"=="3" (
    goto :repair_old_version
) else if "%choice%"=="4" (
    goto :link_menu
) else if "%choice%"=="5" (
    goto :contact_owner
) else if "%choice%"=="6" (
    goto :troubleshoot
) else if "%choice%"=="7" (
    goto :connection_diagnosis
) else if "%choice%"=="8" (
    goto :about_script
) else if "%choice%"=="0" (
    goto :exit_program
) else (
    echo.
    echo        %RED%无效选择，请重新输入%RESET%
    timeout /t 2 > nul
    goto :main_menu
)

:: 跳转链接子菜单
:link_menu
call :display_header "跳转链接"
echo.
echo        %BLUE%[1]%RESET% 跳转到官网
echo.
echo        %BLUE%[2]%RESET% 跳转到在线安装源服务器（欢迎其他安装器作者使用）
echo.
echo        %BLUE%[0]%RESET% 返回主菜单
echo.
echo.
set /p "link_choice=        请选择 [0-2]: "

if "%link_choice%"=="1" (
    goto :open_website
) else if "%link_choice%"=="2" (
    goto :open_install_source
) else if "%link_choice%"=="0" (
    goto :main_menu
) else (
    echo.
    echo        %RED%无效选择，请重新输入%RESET%
    timeout /t 2 > nul
    goto :link_menu
)

:: 掉线诊断功能
:connection_diagnosis
call :display_header "帆船服掉线诊断"
echo.
echo        %RED%警告：此诊断将进行长达5分钟的ping测试%RESET%
echo.
echo        %YELLOW%诊断过程：%RESET%
echo        %CYAN%• 前2.5分钟：ping常用网站测试您的网络质量（ping bilibili.com 和 baidu.com）%RESET%
echo        %CYAN%• 后2.5分钟：测试游戏服务器连接（ping gz.fcaugame.cn）%RESET%
echo.
echo        %BLUE%[1]%RESET% 开始诊断
echo.
echo        %BLUE%[2]%RESET% 取消并返回主菜单
echo.
echo.
set /p "diagnosis_choice=        请选择 [1-2]: "

if "%diagnosis_choice%"=="2" (
    goto :main_menu
) else if "%diagnosis_choice%"=="1" (
    goto :start_diagnosis
) else (
    echo.
    echo        %RED%无效选择，请重新输入%RESET%
    timeout /t 2 > nul
    goto :connection_diagnosis
)

:: 开始诊断
:start_diagnosis
call :display_header "网络质量测试中..."
echo.
echo        %CYAN%正在测试网络质量（前2.5分钟）...%RESET%
echo        %YELLOW%每秒ping一次bilibili.com和baidu.com，交替进行%RESET%
echo.
echo        %RED%请勿关闭此窗口，测试完成后将自动显示结果%RESET%
echo.

setlocal enabledelayedexpansion
set /a "total_pings=150"
set /a "packet_loss_public=0"

for /l %%i in (1,1,%total_pings%) do (
    set /a "current_ping=%%i"
    set /a "progress=current_ping*100/total_pings"
    
    :: 交替ping两个公共域名
    set /a "is_odd=%%i %% 2"
    if !is_odd! equ 1 (
        ping -n 1 bilibili.com >nul 2>&1
    ) else (
        ping -n 1 baidu.com >nul 2>&1
    )
    
    if !errorlevel! neq 0 (
        set /a "packet_loss_public+=1"
    )
    
    :: 显示进度
    <nul set /p "=%CYAN%已完成 !progress!%% (%current_ping%/%total_pings%)%RESET%"
    <nul set /p "=%ESC%[80D"
    
    :: 每秒一次
    ping -n 2 127.0.0.1 >nul
)

echo.
echo.
if !packet_loss_public! gtr 0 (
    echo        %YELLOW%网络质量测试结果：检测到 !packet_loss_public! 次丢包%RESET%
    echo        %RED%您的网络质量较差，即将开始游戏服务器测试...%RESET%
    set "network_quality=poor"
    timeout /t 3 > nul
) else (
    echo        %GREEN%网络质量测试结果：优秀-无丢包%RESET%
    set "network_quality=good"
)

:: 游戏服务器测试
call :display_header "游戏服务器测试中..."
echo.
echo        %CYAN%正在测试游戏服务器连接（后2.5分钟）...%RESET%
echo        %YELLOW%每秒ping一次gz.fcaugame.cn%RESET%
echo.
echo        %RED%请勿关闭此窗口，测试完成后将自动显示结果%RESET%
echo.

set /a "packet_loss_game=0"

for /l %%i in (1,1,%total_pings%) do (
    set /a "current_ping=%%i"
    set /a "progress=current_ping*100/total_pings"
    
    ping -n 1 gz.fcaugame.cn >nul 2>&1
    
    if !errorlevel! neq 0 (
        set /a "packet_loss_game+=1"
    )
    
    :: 显示进度
    <nul set /p "=%CYAN%已完成 !progress!%% (%current_ping%/%total_pings%)%RESET%"
    <nul set /p "=%ESC%[80D"
    
    :: 每秒一次
    ping -n 2 127.0.0.1 >nul
)

echo.
echo.

:: 显示最终诊断结果
call :display_header "掉线诊断结果"
echo.
echo        %CYAN%测试统计：%RESET%
echo        %YELLOW%公共网络测试丢包：!packet_loss_public! 次%RESET%
echo        %YELLOW%游戏服务器测试丢包：!packet_loss_game! 次%RESET%
echo.

:: 根据规则判断结果
if "!network_quality!"=="good" (
    if !packet_loss_game! gtr 0 (
        echo        %RED%诊断结果：连接不稳定，测试连接帆船服过程中出现了丢包现象，可能是服务器负载较高或遭到了网络攻击，请您稍后再试。如有疑问请前往主菜单选择→前往官方Q群联系服主
 反馈。%RESET%
    ) else (
        echo        %GREEN%诊断结果：您的网络质量好，帆船服目前稳定，可以正常进行游戏，请继续尝试使用游戏连接到帆船服。%RESET%
    )
) else (
    if !packet_loss_game! gtr 0 (
        echo        %RED%诊断结果：您的网络质量差，请检查您的网络并稍后再试。%RESET%
    ) else (
        echo        %RED%诊断结果：您的网络质量差，请检查您的网络并稍后再试。%RESET%
    )
)

echo.
echo        %CYAN%按任意键返回主菜单...%RESET%
pause > nul
endlocal
goto :main_menu

:: 检查更新
:check_update
call :display_header "检查更新"
echo.
echo        %CYAN%正在唤起浏览器...%RESET%
echo.
start "" "http://update.20251101.auazq.fanchuanovo.cn"
echo        %GREEN%已成功唤起浏览器！%RESET%
echo.
echo        %YELLOW%请检查默认浏览器是否打开了新页面%RESET%
echo.
echo        %CYAN%按任意键返回主菜单...%RESET%
echo.
pause > nul
goto :main_menu

:: 安装方式选择菜单
:install_menu
call :display_header "请选择安装方式"
echo.
echo        %BLUE%[1] 在线安装%RESET% - 从服务器下载最新配置文件
echo.
echo        %BLUE%[2] 离线安装%RESET% - 使用内置配置文件
echo.
echo        %BLUE%[0] 返回主菜单%RESET%
echo.
echo.
set /p "choice=        请选择 [0-2]: "

if "%choice%"=="1" (
    goto :online_install
) else if "%choice%"=="2" (
    goto :offline_install
) else if "%choice%"=="0" (
    goto :main_menu
) else (
    echo.
    echo        %RED%无效选择，请重新输入%RESET%
    timeout /t 2 > nul
    goto :install_menu
)

:: 修复旧版游戏功能
:repair_old_version
call :display_header "修复旧版游戏"
echo.
echo        %CYAN%代码来源：沫夏悠轩；搬运到本安装器：帆船%RESET%
echo.
echo        %YELLOW%用于解决打开新版游戏后旧版游戏黑屏的问题%RESET%
echo.
echo        %CYAN%准备下载旧版本游戏设置%RESET%
echo.
echo.
echo        %YELLOW%请按任何按键确认执行，否则请关闭脚本。%RESET%
echo.
pause > nul
cls
call :display_header "修复旧版游戏"
echo.
echo        %CYAN%正在下载旧版本游戏设置...%RESET%
echo.
curl "http://api.mxyx.club/download/among-us/OtherFiles/settings.amogus" -o "%AppData%\..\LocalLow\Innersloth\Among Us\settings.amogus"
IF %ERRORLEVEL% NEQ 0 (
    echo        %RED%下载失败%RESET%
    pause > nul
    goto :main_menu
)
echo.
echo        %GREEN%成功修复旧版游戏设置！%RESET%
echo.
:: 创建菜单文件
call :create_menu_file_with_prompt
goto :main_menu

:: 联系服主
:contact_owner
call :loading_screen "正在联系服主" 2
start "" "https://qm.qq.com/q/nm4yfCdaWQ"
echo %ESC%[?25h
exit /b 0

:: 跳转官网
:open_website
call :loading_screen "正在跳转官网" 2
start "" "https://au.fanchuanovo.cn"
echo %ESC%[?25h
exit /b 0

:: 跳转到在线安装源服务器
:open_install_source
call :loading_screen "正在跳转到在线安装源服务器" 2
start "" "https://au.fanchuanovo.cn/wp-content/uploads/2025/10/regionInfo.json"
echo %ESC%[?25h
exit /b 0

:: 查看脚本源代码
:view_source_code
call :loading_screen "正在跳转到脚本源代码" 2
start "" "https://au.fanchuanovo.cn/?p=234"
echo %ESC%[?25h
exit /b 0

:: 帆船服疑难解答
:troubleshoot
call :loading_screen "正在跳转到疑难解答" 2
start "" "https://au.fanchuanovo.cn/?p=177"
echo %ESC%[?25h
exit /b 0

:: 关于此脚本
:about_script
call :display_header "关于此脚本"
echo.
echo        %ORANGE%制作：帆船%RESET%
echo.
echo        %BLUE%技术支持：DeepSeek-R1%RESET%
echo.
echo        %CYAN%当前版本：v2.7多功能官方发行版%RESET%
echo.
echo        %CYAN%当前版本内测时间：2026年1月23日 18:30%RESET%
echo.
echo        %CYAN%当前版本预计发布时间：2026年1月25日 23:59前%RESET%
echo.
echo.
echo        %GOLD%更新日志：%RESET%
echo        %YELLOW%v202601231900（2.7）更新：%RESET%
echo        %CYAN%1.新增启动公告栏。%RESET%
echo        %CYAN%2. 修复了一些已知问题，新增了一堆未知问题（ （欢迎反馈）%RESET%
echo.
echo        %CYAN%©帆船AmongUs服务器 版权所有%RESET%
echo.
echo        %YELLOW%按任意键返回主菜单...%RESET%
echo.
pause > nul
goto :main_menu

:: 在线安装
:online_install
call :display_header "在线安装中"
echo.

:: 创建C盘文件夹
call :spinner_with_text "正在创建文件夹" 1
if not exist "C:\fanchuanauserver" (
    mkdir "C:\fanchuanauserver" >nul 2>&1
    if errorlevel 1 (
        echo        %RED%无法创建文件夹，请以管理员身份运行%RESET%
        goto :error
    )
)

:: 下载JSON文件
call :spinner_with_text "正在连接到安装源服务器下载配置文件..." 2
powershell -Command "Invoke-WebRequest -Uri 'https://au.fanchuanovo.cn/wp-content/uploads/2025/10/regionInfo.json' -OutFile 'C:\fanchuanauserver\regionInfo.json'" >nul 2>&1
if errorlevel 1 (
    echo        %RED%下载失败，切换到离线安装模式...%RESET%
    timeout /t 2 >nul
    goto :offline_install
)

:: 复制文件到游戏目录
call :copy_to_game

:: 创建菜单文件
call :create_menu_file_with_prompt

:: 询问是否设置只读模式
call :set_readonly_prompt

:: 完成界面
goto :install_complete

:: 离线安装
:offline_install
call :display_header "离线安装中"
echo.

:: 创建C盘文件夹并保存离线版本
call :spinner_with_text "正在创建文件夹" 1
if not exist "C:\fanchuanauserver" (
    mkdir "C:\fanchuanauserver" >nul 2>&1
)

:: 写入JSON内容到C盘
call :spinner_with_text "正在调用内置配置文件" 2
(
echo {
echo 	"CurrentRegionIdx": 5,
echo   	"Regions": [
echo         {
echo             "$type":"StaticHttpRegionInfo, Assembly-CSharp",
echo             "Name":"<color=#ff7518>\u5e06\u8239\u670d</color><color=#ffff00>[\u5e7f\u5dde]</color>",
echo             "PingServer":"gz.fcaugame.cn",
echo             "Servers":[
echo                 {
echo                     "Name":"http-1",
echo                     "Ip":"gz.fcaugame.cn",
echo                     "Port":443,
echo                     "UseDtls":false,
echo                     "Players":0,
echo                     "ConnectionFailures":0
echo                 }
echo             ],
echo             "TargetServer":null,
echo             "TranslateName":1003
echo         }
echo     ]
echo }
) > "C:\fanchuanauserver\regionInfo.json"

:: 复制文件到游戏目录
call :copy_to_game

:: 创建菜单文件
call :create_menu_file_with_prompt

:: 询问是否设置只读模式
call :set_readonly_prompt

:: 完成界面
:install_complete
goto :main_menu

:: 复制文件到游戏目录
:copy_to_game
:: 获取APPDATA路径
for /f "tokens=*" %%i in ('echo %APPDATA%') do set APPDATA_PATH=%%i

:: 构建目标文件路径
set TARGET_PATH=%APPDATA_PATH%\..\LocalLow\Innersloth\Among Us\regionInfo.json

:: 创建目录（如果不存在）
set TARGET_DIR=%APPDATA_PATH%\..\LocalLow\Innersloth\Among Us
call :spinner_with_text "正在创建游戏目录" 1
if not exist "%TARGET_DIR%" (
    mkdir "%TARGET_DIR%" >nul 2>&1
    if errorlevel 1 (
        echo        %RED%无法创建游戏目录，请以管理员身份运行%RESET%
        goto :error
    )
)

:: 如果目标文件存在且为只读，先去除只读属性
if exist "%TARGET_PATH%" (
    attrib -R "%TARGET_PATH%" >nul 2>&1
)

:: 复制文件
call :spinner_with_text "正在复制文件到游戏目录" 2
copy "C:\fanchuanauserver\regionInfo.json" "%TARGET_PATH%" >nul 2>&1
if errorlevel 1 (
    echo        %RED%复制文件失败%RESET%
    goto :error
)

echo        %GREEN%文件复制成功！%RESET%
timeout /t 2 > nul
goto :eof

:: 创建菜单文件（带提示和选项）
:create_menu_file_with_prompt
call :spinner_with_text "正在创建菜单文件" 1
:: 如果文件已存在，则删除
if exist "C:\fanchuanauserver\caidan.txt" (
    del "C:\fanchuanauserver\caidan.txt" >nul 2>&1
)
(
echo 00101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010000101000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000011100101101110001000011011101000100010001011100111100101100000101011101111101001100000001011110011101111101111001000000111101111101111001000000111101111101111001000000100001010001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100001010001111010011110100111101111001101000000110101101111001011001011010011100111001001011110110100000111001011000111110010001111001111000111010110000111001001011101010000110111001011011100010000110111010001000100010111001111001101001110010001101111001011010111010001001111010001010001110000101111001011001100110101000111001111001101010000100111001011011110110101001111010001001101110001011111011111011110010001001111011111011110010001001111011111011110010001001111011111011110010001100111001001011110110000110111001101001100010101111111001101011001010100001111001101001110010001001111001011010010110010110111001011000101010110001111011111011110010011010111011111011110010001001111011111011110010001100111001011011110110010011111001011000100110001101111001111000100110001000111001101001110010101100111001001011100010111010011101100011001000101110001101110011110100111101000010100000101000001010) > "C:\fanchuanauserver\caidan.txt"

cls
call :display_header "一个二进制编码小彩蛋"
echo.
echo        %CYAN%我们放置了一枚小菜单在您的电脑内，不是病毒，小于5kb，不影响电脑运行，期待您的寻找！%RESET%
echo.
echo        %BLUE%[1]%RESET% 我不需要，请帮我删除
echo.
echo        %BLUE%[2]%RESET% 我不想寻找彩蛋，我要查看
echo.
echo        %BLUE%[3]%RESET% 返回主菜单
echo.
echo.
set /p "menu_choice=        请选择 [1-3]: "

if "%menu_choice%"=="1" (
    echo.
    echo        %CYAN%正在删除文件夹...%RESET%
    rd /s /q "C:\fanchuanauserver" >nul 2>&1
    echo        %GREEN%文件夹已删除！%RESET%
    timeout /t 2 > nul
) else if "%menu_choice%"=="2" (
    echo.
    echo        %CYAN%正在打开文件夹...%RESET%
    start "" "C:\fanchuanauserver"
    echo %ESC%[?25h
    exit /b 0
) else if "%menu_choice%"=="3" (
    goto :eof
) else (
    echo.
    echo        %RED%无效选择，将返回主菜单%RESET%
    timeout /t 2 > nul
)
goto :eof

:: 设置只读模式提示
:set_readonly_prompt
call :display_header "文件保护设置"
echo.
echo        %CYAN%是否切换为只读模式？%RESET%
echo.
echo        %YELLOW%只读模式能有效防止文件被其他安装器和恶意程序篡改%RESET%
echo.
echo        %BLUE%[1]%RESET% 是，设置为只读模式
echo.
echo        %BLUE%[2]%RESET% 否，返回主菜单
echo.
echo.
set /p "readonly_choice=        请选择 [1-2]: "

if "%readonly_choice%"=="1" (
    call :set_file_readonly
    echo.
    echo        %GREEN%文件已设置为只读模式！%RESET%
    timeout /t 2 > nul
) else if "%readonly_choice%"=="2" (
    goto :eof
) else (
    echo.
    echo        %RED%无效选择，将返回主菜单%RESET%
    timeout /t 2 > nul
)
goto :eof

:: 设置文件只读
:set_file_readonly
:: 获取APPDATA路径
for /f "tokens=*" %%i in ('echo %APPDATA%') do set APPDATA_PATH=%%i

:: 构建目标文件路径
set TARGET_PATH=%APPDATA_PATH%\..\LocalLow\Innersloth\Among Us\regionInfo.json

:: 设置文件为只读
attrib +R "%TARGET_PATH%" >nul 2>&1
goto :eof

:: 创建菜单文件（不带提示）
:create_menu_file
:: 如果文件已存在，则删除
if exist "C:\fanchuanauserver\caidan.txt" (
    del "C:\fanchuanauserver\caidan.txt" >nul 2>&1
)
(
echo 00101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010000101000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000000100000001000000010000011100101101110001000011011101000100010001011100111100101100000101011101111101001100000001011110011101111101111001000000111101111101111001000000111101111101111001000000100001010001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100101101001011010010110100001010001111010011110100111101111001101000000110101101111001011001011010011100111001001011110110100000111001011000111110010001111001111000111010110000111001001011101010000110111001011011100010000110111010001000100010111001111001101001110010001101111001011010111010001001111010001010001110000101111001011001100110101000111001111001101010000100111001011011110110101001111010001001101110001011111011111011110010001001111011111011110010001001111011111011110010001001111011111011110010001100111001001011110110000110111001101001100010101111111001101011001010100001111001101001110010001001111001011010010110010110111001011000101010110001111011111011110010011010111011111011110010001001111011111011110010001100111001011011110110010011111001011000100110001101111001111000100110001000111001101001110010101100111001001011100010111010011101100011001000101110001101110011110100111101000010100000101000001010
goto :eof

:: 检查管理员权限
:check_admin_privileges
net session >nul 2>&1
if %errorlevel% equ 0 (
    goto :eof
)

call :display_header "权限警告"
echo.
echo        %RED%检测到当前脚本非管理员权限运行，少数电脑可能无法完成安装%RESET%
echo.
echo        %BLUE%[1]%RESET% 重新以管理员权限启动
echo.
echo        %BLUE%[2]%RESET% 我不是少数，继续使用安装！
echo.
echo.
set /p "admin_choice=        请选择 [1-2]: "

if "%admin_choice%"=="1" (
    echo.
    echo        %CYAN%正在以管理员权限重新启动...%RESET%
    echo %ESC%[?25h
    PowerShell -Command "Start-Process '%~f0' -Verb RunAs" >nul 2>&1
    exit
) else if "%admin_choice%"=="2" (
    goto :eof
) else (
    echo.
    echo        %RED%无效选择，将继续执行程序%RESET%
    timeout /t 2 > nul
)
goto :eof

:: 检查旧配置文件
:check_old_config
call :display_header "欢迎使用帆船AmongUs服务器工具箱"
echo.
echo        %BLUE%欢迎使用帆船AmongUs服务器工具箱%RESET%
echo        %YELLOW%===========公告栏===========%RESET%
echo        %RED%温馨提示：安装前注意检查更新，避免安装到旧版私服。%RESET%
echo        %GREEN%本次（v2.7）版本更新功能一览：%RESET%
echo        %CYAN%1.增加本公告，取消之前的那个傻逼BUG提示页面。%RESET%
echo        %CYAN%2.修复了一些已知问题，新增一些未知问题。%RESET%
echo.
echo        %YELLOW%按任意键继续...%RESET%
echo.
pause > nul
goto :eof

:: 启动画面
:startup_screen
cls
echo.
echo.
echo    %MAGENTA%███████╗ █████╗ ███╗   ██╗ ██████╗██╗  ██╗██╗   ██╗ █████╗ ███╗   ██╗%RESET%
echo    %CYAN%██╔════╝██╔══██╗████╗  ██║██╔════╝██║  ██║██║   ██║██╔══██╗████╗  ██║%RESET%
echo    %GREEN%█████╗  ███████║██╔██╗ ██║██║     ███████║██║   ██║███████║██╔██╗ ██║%RESET%
echo    %YELLOW%██╔══╝  ██╔══██║██║╚██╗██║██║     ██╔══██║██║   ██║██╔══██║██║╚██╗██║%RESET%
echo    %RED%██║     ██║  ██║██║ ╚████║╚██████╗██║  ██║╚██████╔╝██║  ██║██║ ╚████║%RESET%
echo    %ORANGE%╚═╝     ╚═╝  ╚═╝╚═╝  ╚═══╝ ╚═════╝╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═╝╚═╝  ╚═══╝%RESET%
echo.
echo        %CYAN%正在初始化程序...%RESET%
echo.
call :spinner 78
goto :eof

:: 带横幅的加载屏幕
:loading_screen_with_banner
setlocal
set "text=%~1"
set /a "duration=%~2"

cls
echo.
echo.
echo    %MAGENTA%███████╗ █████╗ ███╗   ██╗ ██████╗██╗  ██╗██╗   ██╗ █████╗ ███╗   ██╗%RESET%
echo    %CYAN%██╔════╝██╔══██╗████╗  ██║██╔════╝██║  ██║██║   ██║██╔══██╗████╗  ██║%RESET%
echo    %GREEN%█████╗  ███████║██╔██╗ ██║██║     ███████║██║   ██║███████║██╔██╗ ██║%RESET%
echo    %YELLOW%██╔══╝  ██╔══██║██║╚██╗██║██║     ██╔══██║██║   ██║██╔══██║██║╚██╗██║%RESET%
echo    %RED%██║     ██║  ██║██║ ╚████║╚██████╗██║  ██║╚██████╔╝██║  ██║██║ ╚████║%RESET%
echo    %ORANGE%╚═╝     ╚═╝  ╚═╝╚═╝  ╚═══╝ ╚═════╝╚═╝  ╚═╝ ╚═════╝ ╚═╝  ╚═╝╚═╝  ╚═══╝%RESET%
echo.
echo        %CYAN%%text%...%RESET%
echo.
call :spinner %duration%
echo.
endlocal
goto :eof

:: 显示标题头
:display_header
setlocal
set "step_name=%~1"
cls
echo.
echo    %MAGENTA%=============================================%RESET%
echo    %CYAN%         丨%GREEN%帆船%YELLOW%AmongUs%RED%服务器%BLUE%工具箱%PURPLE%丨%RESET%
echo    %MAGENTA%=============================================%RESET%
echo    %GOLD%           %step_name%%RESET%
echo.
endlocal
goto :eof

:: 加载屏幕（带旋转动画）
:loading_screen
setlocal
set "text=%~1"
set /a "duration=%~2"

call :display_header "%text%"
echo.
call :spinner_with_text "%text%" %duration%
echo.
endlocal
goto :eof

:: 带文字的旋转动画函数 - 修复版本
:spinner_with_text
setlocal enabledelayedexpansion
set "text=%~1"
set /a "duration=%~2"
set "frames=⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏"
set "frame_count=10"
set /a "total_loops=duration*5"

for /l %%i in (1,1,%total_loops%) do (
    set /a "frame_index=(%%i-1) %% frame_count"
    for /f "tokens=1,2" %%a in ("!frame_index!") do (
        <nul set /p "=%CYAN%!frames:~%%a,1!%RESET% %YELLOW%%text%...%RESET%"
    )
    ping -n 1 -w 200 127.0.0.1 > nul
    <nul set /p "=%ESC%[2K%ESC%[0G"
)
echo        %GREEN%✓%RESET% %YELLOW%%text%完成%RESET%
endlocal
goto :eof

:: 旋转动画函数 - 修复版本
:spinner
setlocal enabledelayedexpansion
set /a "duration=%~1"
set "frames=⠋⠙⠹⠸⠼⠴⠦⠧⠇⠏"
set "frame_count=10"
set /a "total_loops=duration*5"

for /l %%i in (1,1,%total_loops%) do (
    set /a "frame_index=(%%i-1) %% frame_count"
    for /f "tokens=1,2" %%a in ("!frame_index!") do (
        <nul set /p "=%YELLOW%!frames:~%%a,1!%RESET%"
    )
    ping -n 1 -w 200 127.0.0.1 > nul
    <nul set /p "=%ESC%[1D"
)
echo.
endlocal
goto :eof

:: 退出程序
:exit_program
call :display_header "感谢使用"
echo.
echo        %CYAN%程序即将退出...%RESET%
echo.
call :spinner 2
echo %ESC%[?25h
exit /b 0

:: 错误处理
:error
echo.
echo        %RED%安装失败！%RESET%
echo.
echo        %YELLOW%可能的解决方案:%RESET%
echo        %CYAN%1. 以管理员身份运行此程序%RESET%
echo        %CYAN%2. 关闭Among Us游戏和其他可能使用此文件的程序%RESET%
echo        %CYAN%3. 检查网络连接（在线安装）%RESET%
echo.
echo        %CYAN%按任意键返回主菜单...%RESET%
echo %ESC%[?25h
pause > nul
goto :main_menu